/*Name: Garima Verma
 * Student number: 991807497
 * Date: 5 April, 2025
 */
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Scanner;

public class App {
    public static void main(String[] args) {
        // for input file, file class object is created
        String inputFilePath = "/Users/sakshamverma/Downloads/exampleBmiCalculator/src/BMIdata.dat";
        File inFile = new File(inputFilePath);
        Scanner sc = null;

        // Try-catch block to catch and handle the FileNotFoundException for input file
        try {
            // Create a Scanner class object to read data from the input file
            sc = new Scanner(inFile);
        } catch (FileNotFoundException fileNotFound) {
            System.out.println(fileNotFound);
            String inputFilePath1 = "/Users/sakshamverma/Downloads/exampleBmiCalculator/src/BMIdata.dat";
            inFile = new File(inputFilePath1);
            try {
                sc = new Scanner(inFile);
            } catch (FileNotFoundException e) {
                System.out.println("Second input file not found. Exiting application.");
                return; // Exit the application if the second file is also not found
            }
            System.out.println("File not found exception handled.");
        }

        // Create a File class object for the output file "\BMIstatus.txt"
        File outFile = new File("BMIstatus.txt");
        PrintWriter pWriter = null;

        // Try-catch block to handle FileNotFoundException for PrintWriter
        try {
            //  PrintWriter object is created to write data to the output file
            pWriter = new PrintWriter(outFile);
        } catch (FileNotFoundException e) {
            System.out.println("Error creating output file: " + e.getMessage());
            return; //  application is exit if the output file cannot be created
        }

        // Create a list collection object for the BMI objects
        ArrayList<BMI> bmiList = new ArrayList<>();

        // Read data from the input file (one line at a time),
        // Create a BMI object, and add the BMI object to the List
        while (sc.hasNext()) {
            String name = sc.next();
            int age = sc.nextInt();
            double weight = sc.nextDouble();
            double height = sc.nextDouble();
            BMI bmi = new BMI(name, age, weight, height);
            bmiList.add(bmi);
        }
        sc.close();
        System.out.println("BMI data read from the input file");

        // Write the BMI objects from the list to the output file formatted
        // as required by the application
        for (int i = 0; i < bmiList.size(); i++) {
            pWriter.printf("\nBMI for ----");
            pWriter.printf("\nName: %-15s", bmiList.get(i).getName());
            pWriter.printf("\nAge: %3d", bmiList.get(i).getAge());
            pWriter.printf("\nWeight: %6.2f Kilograms", bmiList.get(i).getWeightInKg());
            pWriter.printf("\nHeight: %6.2f Meters", bmiList.get(i).getHeightInMeters());
            pWriter.printf("\nComputed BMI: %6.2f kg/Meter^2", bmiList.get(i).getBMI());
            pWriter.printf("\nStatus: %-50s\n", bmiList.get(i).getStatus());
        }
        pWriter.close();
        System.out.println("Computed BMI data written to the output file");
        System.out.println("Thank you for using the BMI application.");
    }
}